# WooCommerce Room Booking System

## Overview

This is a complete room booking system built on top of WooCommerce, converting products into bookable rooms with a premium booking interface.

## Features

### ✅ Completed Features

1. **Product to Room Conversion**
   - Changed product slug from `/product/` to `/rooms/`
   - Renamed all product terminology to "Rooms"
   - Renamed "Categories" to "Room Categories"
   - Renamed "Attributes" to "Room Attributes"

2. **Custom Room Fields**
   - Room size (sq ft)
   - Occupancy details
   - Maximum guests
   - Room type (Single, Double, Twin, Suite, Deluxe, Presidential)
   - View (Ocean, Garden, City, Mountain, Pool)
   - Bed type
   - Amenities (WiFi, TV, AC, Minibar, Safe, Balcony, etc.)
   - Pricing type (Per Night, Per Person, Per Night Per Person)
   - Price per night / per person
   - Deposit percentage
   - Minimum/Maximum stay
   - Check-in/Check-out times
   - Extra services with pricing

3. **Single Room Page Layout**
   - **Left Side (Main Content):**
     - Room title and rating
     - Image gallery with slider
     - Room description
     - Room details grid (size, occupancy, type, view, bed type)
     - Amenities section with icons
     - Pricing information
     - Extra services list
     - Availability calendar
     - Related rooms
   
   - **Right Side (Sticky Booking Sidebar):**
     - Check-in date picker
     - Check-out date picker
     - Guests selector (adults, children)
     - Extra services checkboxes
     - Live price calculation
     - Payment options (Full payment / Deposit)
     - Deposit and remaining balance display
     - "Book Now" button
     - "Ask a Question" inquiry form

4. **Booking Calendar & Availability**
   - Real-time availability checking
   - Booked dates automatically blocked
   - Minimum stay validation
   - Maximum stay validation
   - Maximum guests validation
   - Prevents double bookings
   - Calendar integration with Flatpickr

5. **Archive Page (Room Listing)**
   - Clean room grid layout
   - Room image
   - Short excerpt
   - Price per night
   - "View Room" button
   - Filters sidebar:
     - Category filter
     - Price range filter
     - Occupancy filter
     - Amenities filter

6. **Partial Payment System**
   - Full payment option
   - Partial deposit (percentage or fixed)
   - Automatic remaining balance calculation
   - Deposit displayed in booking sidebar
   - Payment type selection

7. **Booking Logic**
   - Availability checking based on orders
   - Prevents double bookings
   - Validates minimum/maximum stay
   - Validates guest count
   - Saves booking data to order meta
   - Displays booking details in cart and checkout

## Installation Instructions

### Step 1: Activate the Child Theme

1. Go to **Appearance > Themes** in WordPress admin
2. Activate the **Tourm Child** theme
3. The room booking system will be automatically enabled

### Step 2: Flush Rewrite Rules

1. Go to **Settings > Permalinks**
2. Click **Save Changes** (this flushes rewrite rules)
3. Your product URLs will now be `/rooms/` instead of `/product/`

### Step 3: Configure WooCommerce

1. Ensure WooCommerce is installed and activated
2. Go to **WooCommerce > Settings**
3. Make sure your shop page is set up correctly

### Step 4: Set Up Your First Room

1. Go to **Rooms > Add New** (formerly Products)
2. Fill in the room details:
   - **Room Details Meta Box:**
     - Room size
     - Occupancy
     - Max guests
     - Room type
     - View
     - Bed type
     - Select amenities
   
   - **Room Pricing Settings:**
     - Choose pricing type
     - Set price per night
     - Set price per person (if applicable)
     - Set deposit percentage
   
   - **Room Availability Settings:**
     - Minimum stay (nights)
     - Maximum stay (nights)
     - Check-in time
     - Check-out time
   
   - **Extra Services:**
     - Add services with name, price, and type

3. Set the regular WooCommerce price (this will be used as fallback)
4. Publish the room

## Usage Guide

### For Site Administrators

#### Adding a New Room

1. Navigate to **Rooms > Add New**
2. Enter room title and description
3. Add room images (featured image + gallery)
4. Fill in all custom fields in the meta boxes
5. Set the WooCommerce price
6. Publish

#### Managing Bookings

- Bookings are stored as WooCommerce orders
- View bookings in **WooCommerce > Orders**
- Each order contains:
  - Check-in date
  - Check-out date
  - Number of adults/children
  - Selected extra services

#### Setting Up Extra Services

1. Edit a room
2. Scroll to **Extra Services** meta box
3. Click **Add Extra Service**
4. Enter:
   - Service name
   - Price
   - Type (Per Night, Per Stay, Per Person)
5. Click **Remove** to delete a service

### For Customers

#### Booking a Room

1. Visit the **Rooms** page (`/rooms/`)
2. Browse available rooms
3. Click **View Room** on a room
4. On the room page:
   - Select check-in date
   - Select check-out date
   - Choose number of adults and children
   - Select extra services (optional)
   - Choose payment option (Full or Deposit)
   - Review the price breakdown
   - Click **Book Now**
5. Complete checkout process

#### Asking Questions

1. On any room page, click **Ask a Question**
2. Fill in the inquiry form
3. Submit - the inquiry will be emailed to the site administrator

## File Structure

```
tourm-child/
├── functions.php                          # Main functionality
├── style.css                              # Child theme styles
├── woocommerce/
│   ├── single-product.php                 # Single room template
│   ├── archive-product.php                # Rooms archive template
│   └── single-product/
│       └── booking-form.php               # Booking sidebar form
├── assets/
│   ├── css/
│   │   └── room-booking.css               # Room booking styles
│   └── js/
│       └── room-booking.js                # Booking functionality
└── ROOM-BOOKING-README.md                 # This file
```

## Customization

### Changing Colors

Edit `assets/css/room-booking.css` and modify the color values:
- Primary color: `#007bff` (used for buttons, links)
- Text color: `#1a1a1a`
- Background: `#f8f9fa`

### Modifying Layout

- Single room template: `woocommerce/single-product.php`
- Booking form: `woocommerce/single-product/booking-form.php`
- Archive template: `woocommerce/archive-product.php`

### Adding Custom Amenities

Edit `functions.php` and find the `$available_amenities` array in the `room_details_meta_box_callback` function. Add your custom amenities there.

### Changing Default Deposit Percentage

Edit `functions.php` and find:
```php
if ( empty( $deposit_percentage ) ) {
    $deposit_percentage = 30; // Change this value
}
```

## Technical Details

### Dependencies

- **WooCommerce** (required)
- **jQuery** (included with WordPress)
- **Flatpickr** (loaded via CDN for date picker)
- **Swiper** (loaded via CDN for image gallery)

### AJAX Endpoints

- `get_room_availability` - Get booked dates for a room
- `calculate_booking_price` - Calculate booking total
- `send_room_inquiry` - Send inquiry email

### Database

- Room data stored in post meta
- Booking data stored in order item meta
- No custom tables required

### Security

- All inputs are sanitized
- Nonces used for AJAX requests
- User capabilities checked
- SQL injection prevention via WordPress functions

## Troubleshooting

### Permalinks Not Working

1. Go to **Settings > Permalinks**
2. Click **Save Changes**
3. Clear any caching plugins

### Calendar Not Showing

1. Check browser console for JavaScript errors
2. Ensure Flatpickr is loading (check Network tab)
3. Verify jQuery is loaded

### Price Calculation Not Working

1. Check browser console for AJAX errors
2. Verify room has pricing set in meta boxes
3. Check that dates are selected

### Bookings Not Saving

1. Verify WooCommerce is active
2. Check order meta in database
3. Ensure booking data is being passed in form

## Support

For issues or questions:
1. Check this README first
2. Review browser console for errors
3. Check WordPress debug log
4. Verify all required plugins are active

## Future Enhancements (Optional)

- Seasonal pricing
- Multi-room booking
- Booking calendar widget
- Email notifications for bookings
- Booking management dashboard
- Integration with payment gateways for deposits
- Booking confirmation emails
- Cancellation policy management

## License

This code is part of the Tourm Child theme and follows the parent theme's license.

---

**Version:** 1.0.0  
**Last Updated:** 2024  
**Compatible with:** WooCommerce 5.0+, WordPress 5.0+
