<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Shape Widget .
 *
 */
class tourm_Shape extends Widget_Base {

	public function get_name() {
		return 'tourmshape';
	}
	public function get_title() {
		return __( 'Shape Box', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'Shape Box', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] ); 

	

		$this->end_controls_section();



        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// tourm_common_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .sec-title', [ '1' ] );
	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="elements-sec bg-white overflow-hidden">';
		        echo '<div class="container-fluid">';
		            echo '<div class="tags-container relative"></div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}